//+------------------------------------------------------------------+
//|                                                 VanessaFX 4H.mq4 |
//|                               Copyright  2006, Taylor Stockwell |
//|                                               stockwet@yahoo.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Taylor Stockwell"
#property link      "stockwet@yahoo.com"

/*
Version: 1.0
Developed: 1/19/2007

Notes, etc.
This expert produces signals when the VanessaFX 4H Advanced signal is seen on a chart. It
must be attached to a 4h chart and you must have the MACD No Histogram.mq4 file compiled
and installed.


*/

//=============== external inputs





//=============== global vars
int signalBar=0;
int lastBars;


//===========================  Get Values Functions  ============================
double macdVal(int shift, int line)
{
   //For "line", use 0 as MACD and 1 as Signal
   double val = iCustom(NULL, 0, "MACD  NO Histogram", 12,26,9,line,shift);
   return(NormalizeDouble(val,8));
}

double psarVal(int shift)
{
  double val = iSAR(NULL,0,0.02,0.2,shift);
  return(val);
}

double maVal(int per, int shift)
{
  double val = iMA(NULL,0,per,0,MODE_EMA,PRICE_CLOSE,shift);
  return(val);
}

//===========================  Check Crossings  ============================
bool mdcrossSig()
{
   string presig, cursig;
   bool cross = false;
   double md0 = macdVal(0,0);
   double md1 = macdVal(1,0);
   double ms0 = macdVal(0,1);
   double ms1 = macdVal(1,1);
   
   if(md0 > ms0) cursig = "up";
   else if(md0 < ms0) cursig = "dn";
   
   if(md1 > ms1) presig = "up";
   else if(md1 < ms1) presig = "dn";
   
   if(presig != cursig) cross = true;
   else if(presig == cursig) cross = false;
   
   return(cross);  
   
}

bool macrossSig()
{
   string presig, cursig;
   bool cross = false;
   double maf0 = maVal(6,0);
   double maf1 = maVal(6,1);
   double mas0 = maVal(13,0);
   double mas1 = maVal(13,1);
   
   if(maf0 > mas0) cursig = "up";
   else if(maf0 < mas0) cursig = "dn";
   
   if(maf1 > mas1) presig = "up";
   else if(maf1 < mas1) presig = "dn";
   
   if(presig != cursig) cross = true;
   else if(presig == cursig) cross = false;
   
   return(cross);  
   
}


void sendAlert(string alert)
{
   if(alert=="max")
      SendMail("VanessaFX Alert - Primary", "The moving averages have crossed on "+Symbol()+
      ". Please view the charts for a possible trade.");
   else if(alert == "mdx")
      SendMail("VanessaFX Alert - Secondary", "The MACD line has crossed with the signal line on "+Symbol()+
      ". This may confirm a setup or be a prelude to a trade.");
}


bool checkBar()
{
   bool barOK;
  if (lastBars != Bars) barOK = true;
  else barOK = false;

  return(barOK);
}

//=============== function: init
int init()
  {
   lastBars = Bars;
   return(0);
  }

//=============== function: deinit
int deinit()
  {

   return(0);
  }

//=============== function: start
int start()
  {

   if(checkBar() == true)
   {
      
      if(signalBar != Bars)
      {
      if(mdcrossSig() == true)
      sendAlert("mdx");
      
      if(macrossSig() == true)
      sendAlert("max");
      
      signalBar = Bars;
      }
   lastBars = Bars;
   }
   
   //Comment("Cur Bar: ", Bars,"\nLast Bar: ", lastBars,
   //"\nAlert Bar: ", signalBar);
   return(0);
  }

